#include <windows.h>
#include <stdio.h>
#include <tlhelp32.h>
#include <vdmdbg.h>
#include <tchar.h>

BOOL CALLBACK EnumWindowsProc(HWND hwnd, LPARAM lParam)
{
    _TCHAR szTitle[MAX_PATH] = {0, };
    DWORD dwPID = 0;
	
    PROCESSENTRY32 pEntry;
    memset(&pEntry, 0x00, sizeof(PROCESSENTRY32));
    pEntry.dwSize = sizeof(pEntry);
	
    // process list(like taskmgr)
    DWORD exStyle = GetWindowLong(hwnd, GWL_EXSTYLE);
    BOOL isVisible = IsWindowVisible(hwnd);
    BOOL isToolWindow = (exStyle & WS_EX_TOOLWINDOW);
    BOOL isAppWindow = (exStyle & WS_EX_APPWINDOW);
    BOOL isOwned = GetWindow(hwnd, GW_OWNER) ? TRUE : FALSE;
	
    if (!(isVisible && (isAppWindow || (!isToolWindow && !isOwned))))
        return TRUE;
	
    GetWindowText(hwnd, szTitle, MAX_PATH); // get caption
    GetWindowThreadProcessId(hwnd, &dwPID);
	
    HANDLE hSnapShot = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, dwPID);
    Process32First(hSnapShot, &pEntry);
	
    HANDLE hProcess = OpenProcess(PROCESS_QUERY_INFORMATION, FALSE, dwPID);
	
    while (!(dwPID == pEntry.th32ProcessID) && IsWindowVisible(hwnd))
    {
        if (FALSE == Process32Next(hSnapShot, &pEntry))
            break;
		
        hProcess = OpenProcess(PROCESS_QUERY_INFORMATION, FALSE, dwPID);
    }
	
    _TCHAR szRes[MAX_PATH] = {0, };
    _stprintf(szRes, _T("PID : 0x%08x, Title : %s, Filename : %s\n"), dwPID, szTitle, pEntry.szExeFile);
	_tprintf( szRes );
	
    return TRUE;
}